# videojuke

A skinable video jukebox.

## Getting Started

Copy the application files to a location of your choice, preserving the sub-folders as provided.

To launch the application, double-click the 'StartJuke.bat' file.

When the application is first launched, it will check to verify if you've already registered the application (removing the 24 track limit).

## Configuration

This section outlines the settings available in the `jukebox.ini` file.
This file allows you to customize various aspects of the jukebox, from where it finds your music to how it looks and behaves.

## How to Edit `jukebox.ini`

The `jukebox.ini` file is a plain text file. You can open and edit it with any text editor, such as Notepad. The file is located in the base directory of your Video Jukebox installation. If you haven't created one, it will be created for you the first time you run the jukebox.

The file is divided into sections, each starting with a name in square brackets (e.g., `[Index]`). Under each section are a series of key-value pairs (e.g., `UseID3 = True`). To change a setting, you simply need to change the value after the equals sign.

Lines that start with a semicolon (`;`) or a hash (`#`) are comments and are ignored by the jukebox. They're just there to provide explanations for the settings. Below, you'll find the options for each section (roughly in order of importance), to assist you in editing the appearance and functionality of the jukebox.

## `[Index]` Section

This section controls how the jukebox finds and indexes your music and video files.

*   **`SongPath`**: Specifies the folders where the jukebox should look for media files. You can have up to 50 paths, numbered as `SongPath1`, `SongPath2`, and so on.
    *   Example: `SongPath1 = C:\Users\YourName\Music\`

*   **`UseID3`**: If set to `True`, the jukebox will read metadata (like artist, album, and title) from the files themselves (ID3 tags). If `False`, it will attempt to guess this information from the file and folder names.
    *   Default: `True`

*   **`UpdateIndex`**: If `True`, the jukebox will rescan all media folders every time it starts. This is useful if you frequently add or remove files. If `False`, it will load the last saved index, which is much faster.
    *   Default: `False`

*   **`FilenameCrop`**: This setting helps clean up song titles when not using ID3 tags. The supported modes are `Smart`, `Disabled`, plus a new mode, `Split5` (for Files with 5 fields separated by hyphens in strict order, eg: AlbumName-DiskNumber-TrackNumber-Artist-TrackTitle). These mode try to intelligently extract the artist and album information from the filename.
    *   Default: `Smart`

*   **`DefaultAlbum`**: The album name to use when one cannot be determined.
    *   Default: `Singles`

*   **`DefaultArtist`**: The artist name to use when one cannot be determined.
    *   Default: `Various Artists`

*   **`CoverArt`**: Defines the filenames to search for as cover art in a song's folder if no embedded art is found. You can specify multiple filenames.
    *   Example: `CoverArt1 = folder.jpg`

*   **`StrictAlbum`**: For common album names like "Greatest Hits", this ensures that only songs in the same folder are considered part of the same album. You can list multiple album titles.
    *   Example: `StrictAlbum1 = Greatest Hits`


## `[Display]` Section

This section controls the appearance of the jukebox on your screen.

*   **`SingleScreenMode`**: If `True`, the jukebox will only use a single screen, even if a second one is available.
    *   Default: `False`

*   **`PrimaryDisplay`**: Specify which display number should be used for the media selection display.
    *   Default: `0` (auto-select largest available)

*   **`Skin`**: Sets the skin (visual theme) for the jukebox. You can specify multiple skins (`Skin1`, `Skin2`, etc.) and cycle through them (by default, F10 & F9 select the next/previous skin).
    *   Example: `Skin1 = Default`

*   **`NotificationsEnabled`**: If `True`, the jukebox will show pop-up messages at the bottom of the screen.
    *   Default: `true`

*   **`StartFullscreen`**: If `True`, the jukebox will start in fullscreen mode.
    *   Default: `false`

*   **`InsertCoinMsg1` / `InsertCoinMsg2`**: The messages displayed when a user tries to make a selection without any credits.
    *   Default: `No Selections Remaining` and `Insert Coin`

*   **`AnimationSpeed`**: Sets the speed of page-turning animations (lower is faster). A value of `0` or `Disabled` turns off animations (NB: Not currently enabled).
    *   Default: `80`

*   **`AnimationAcceleration`**: Controls how quickly the page-turning animation speeds up when holding down the button (NB: Not currently enabled). A value of `0` or `Disabled` turns off acceleration.
    *   Default: `80`

*   **`IconFocusBoxThickness` / `TrackFocusBoxThickness`**: Sets the thickness of the focus box around selected icons and tracks. `Auto` adjusts based on resolution, and `0` or `DISABLED` hides it.
    *   Default: `Auto`


## `[Settings]` Section

This section contains general operational settings for the jukebox.

*   **`AllowDuplicatesInQueue`**: If `False`, the same song cannot be added to the upcoming songs queue more than once.
    *   Default: `False`

*   **`AllowStaleDupes`**: If `True`, a song can be added to the queue again after it has been played.
    *   Default: `true`

*   **`AllowSelectFullCD`**: If `True`, selecting track 0 on an album will add all songs from that album to the queue. (NB: Not currently enabled).
    *   Default: `True`

*   **`ArtworkCacheFolder`**: The folder where the jukebox will store cached album art. This folder is required for artwork to be displayed.
    *   Default: `Album.Art`

*   **`ArtworkTransparency`**: Sets the transparency of the album art. `0` is fully transparent (invisible), and `255` is fully opaque.
    *   Default: `80`

*   **`AutoFlipTimer` / `FirstAutoFlipTimer`**: These settings automatically turn the pages of the jukebox after a set number of seconds. `Disabled` turns this feature off. (NB: Not currently enabled).
    *   Default: `Disabled`

*   **`DebugLevel`**: Sets the level of detail (0-5) for logging. `0` means no logging, while higher numbers produce more detailed logs for troubleshooting.
    *   Default: `1`

*   **`Coin1Credit` - `Coin4Credit`**: Sets the number of credits given for each coin slot.
    *   Default: `Coin1Credit = 1`, others `0`

*   **`DisplayOutputFile`**: If you want to output the currently playing track information to a text file (for use with other programs), specify the filename here.
    *   Default: `display.txt`

*   **`EnableVisualisation`**: If `False`, the visualization/video playback window will be disabled.
    *   Default: `True`

*   **`ExtensionsAudio` / `ExtensionsVideo`**: The comma-separated list of file extensions to be included in the index for audio and video files.
    *   Example: `ExtensionsAudio="flac,ogg,m4a,mp3,wav"`

*   **`HardMute`**: If `true`, pressing volume up/down will not unmute the jukebox if it was muted.
    *   Default: `true`

*   **`IgnoreLeadingArticleArtist` / `IgnoreLeadingArticleAlbum`**: If `true`, the jukebox will ignore "The " at the beginning of artist or album names for better sorting (e.g., "The Beatles" becomes "Beatles, The").
    *   Default: `IgnoreLeadingArticleArtist = true`, `IgnoreLeadingArticleAlbum = false`

*   **`IntroMusic`**: The sound file to play when the jukebox starts.
    *   Default: `\skins\sounds\intro_ambient.mp3`

*   **`LoopMode`**: If `Enabled`, songs will be added back to the queue immediately after they finish playing.
    *   Default: `Disabled`

*   **`MaxRandomSonglength`**: The maximum length (in minutes) of a song that can be chosen when in random or radio mode.
    *   Default: `8`

*   **`MaxQueueSize`**: The maximum number of tracks that can be in the "coming up" queue.
    *   Default: `250`

*   **`MostPopularDisplayTime`**: The number of seconds to show the "most popular" songs list before switching back to the "upcoming songs" list. (NB: Not currently enabled).
    *   Default: `5`

*   **`OverlayDisabled`**: Set to `True` to turn off the media information overlay (song title, artist, etc.) that appears over screensavers.
    *   Default: `False`

*   **`OverlayFontSize` / `OverlayFontFace` / `OverlayFontColour`**: These settings control the font size, face, and color for the different parts of the media information overlay.

*   **`RequireCredits`**: If `True`, selections can only be made if there are credits available.
    *   Default: `False`

*   **`PlayStimulatorDelay`**: The number of seconds the jukebox must be idle before it randomly plays a song. `Disabled` turns this off.
    *   Default: `Disabled`

*   **`RadioMode`**: If `Enabled`, the jukebox will continuously play random songs when idle.
    *   Default: `Enabled`

*   **`ResourcePath`**: Specifies additional folders to search for skin resources like images and fonts.
    *   Default: `skins`

*   **`SelectionNumberDisplayed`**: If `true`, the selection number for each track is displayed on the title card.
    *   Default: `true`

*   **`SongSort`**: Determines the default sort order for your music. Can be `Album`, `Artist`, `Popularity`, `Random`, `Title`, `Type`, or `Unsorted`.
    *   Default: `Artist`

*   **`SystemShutdownEnabled`**: If `True`, the jukebox can shut down the computer when it exits. (NB: Not currently enabled).
    *   Default: `False`

*   **`VideoFileColor`**: The color used to distinguish video files from audio files on title cards.
    *   Default: `Deep Purple`

*   **`VisualisationTransparency`**: Sets the transparency of the visualization/video window. `0` is fully transparent, and `255` is fully opaque.
    *   Default: `75`


## `[Controls]` Section

This section configures input devices like keyboards, mice, and gamepads.

*   **`Controls`**: The file that defines the control key mappings.
    *   Default: `controls.ini`

*   **`KeyRepeatRate`**: How many times per second a key press will repeat when held down.
    *   Default: `2`

*   **`AutoSelect`**: If `True`, a selection is made as soon as the selection keys are pressed. If `False`, a separate "Select" button must be pressed.
    *   Default: `True`

*   **`Mouse`**: Can be `Enabled` (visible pointer), `Touchscreen` (invisible pointer), or `Disabled`.
    *   Default: `Enabled`

*   **`ShowKeys`**: If `True`, the name of the last key pressed is shown in the corner of the screen. This is useful for configuring controls. (NB: Not currently enabled).
    *   Default: `False`


## `[VolumeControl]` Section

This section manages volume settings.

*   **`Volume`**: The initial volume of the jukebox (0-100).
    *   Default: `10`

*   **`SoundEffectsVolume`**: The volume of sound effects as a percentage of the main volume.
    *   Default: `50`

*   **`SoundEffectsVolumeWhenPlaying`**: The volume of sound effects while a song is playing.
    *   Default: `30`

*   **`VolumeIncrement`**: The amount the volume changes with each press of the volume up/down buttons.
    *   Default: `10`


## `[ScreenSaver]` Section

This section controls the built-in screensaver.

*   **`ScreenSaver`**: The type of screensaver to use. Options include `Blank`, `Bubbles`, `Lines`, `Maze`, `Mondrian`, `Pipes`, `Rain`, `Slideshow`, `Stars`, `Tron`, `Warp`, and `Windows`. `RANDOM` will selecta new one each time screensaver starts.
    *   Default: `Lines`

*   **`ShowCoverArt`**: If `True`, the album art will be displayed underneath the screensaver effect.
    *   Default: `True`

*   **`ScreenSaverTimeout`**: The number of minutes of inactivity before the screensaver starts. `0` or `DISABLED` to disable.
    *   Default: `0.25`

*   **`SlideShowPath`**: The folder containing images for the `Slideshow` screensaver.
    *   Default: `Album.Art`

*   **`ShowSongInfo`**: If `True`, the current song information will be displayed during the screensaver.
    *   Default: `True`


## `[system]` Section

This section contains system-level settings.

*   **`MouseOverToolTipsEnabled`**: If `True`, tooltips will appear when you hover the mouse over controls.
    *   Default: `True`

*   **`HideMousePointer`**: If `True`, the mouse pointer will automatically hide after a period of inactivity.
    *   Default: `True`

*   **`BackupDBOnExit`**: If `True`, the music database will be backed up when the jukebox closes.
    *   Default: `True`


## Editing `control.ini`

The `control.ini` file is a plain text file.

This file must be present in the root directory of your VideoJukebox setup. If not found at startup, a default configuration will be created for you.

It's used to map physical inputs (keyboard keys, joystick buttons, mouse inputs) to jukebox functions (like play, pause, volume control, navigation, etc.). This allows you to fully customize how you control the jukebox via:

*   Keyboard (including function keys and number pad)
*   Gamepads / joysticks (multiple supported)
*   Mouse

## Key Features

*   Flexible key mapping: Multiple keys can be assigned to the same jukebox function.
*   Unassigned functions (i.e., mapped to 0) are disabled — useful for coin-op or public use setups.
*   Joystick and gamepad support: Up to four joysticks supported.
*   Volume, skin control, screenshot, and other system-level functions included.

Each input (like KEY_A, JOY1_BUTTON1, etc.) is mapped to a BTN_* function.
If an input is mapped to 0, that input is disabled.
You can assign the same BTN_* to multiple inputs (e.g., both a keyboard key and joystick button can select a song).
You can safely remove or comment out keys you're not using, or just map them to `0`.

Here’s a summary of the common BTN_* functions used in VideoJukebox:

BTN_* Code		Description
BTN_SELECT		Select song / confirm
BTN_SKIP		Skip current song
BTN_CLEARQUEUE	Clear the upcoming song queue
BTN_PAUSE		Pause/resume playback
BTN_SHUFFLE		Toggle Shuffle play mode
BTN_VOL_UP		Volume up
BTN_VOL_DOWN	Volume down
BTN_VOL_MUTE	Toggle mute
BTN_SHUTDOWN	Exit the program
BTN_SCREENSHOT	Take a screenshot
BTN_GUI_SELECT	Queue to currently selected item
BTN_GUI_LEFT/RIGHT/UP/DOWN	Move the selection pointer
BTN_FREEPLAY	Toggle free play mode
BTN_COIN1		Simulate a coin insertion (ie, add a credit)
BTN_ZOOM		Zoom UI (fullscreen toggle)
BTN_SKIN_NEXT	Next visual skin/theme

## Button functions
BTN_0-BTN_9			Numeric selector keys.
BTN_A-BTN_Z			Alphabetic selector keys.
BTN_BACKSPACE	Clears the last entered (selector) button. By default, this is mapped to the Backspace key on the keyboard.
BTN_COIN1			Process coin insertion 1
BTN_COIN2			Process coin insertion 2
BTN_COIN3			Process coin insertion 3
BTN_COIN4			Process coin insertion 4
BTN_CLEARQUEUE		Clear the upcoming selections queue.
BTN_COMINGUPSCROLL	Advance to the next page of upcoming selections.
BTN_EXIT			Exit the application (clean shutdown).
BTN_FIRSTPG			Move selection pointer to first page of media.
BTN_FREEPLAY		Toggle free play mode on/off
BTN_FREEPLAY_OFF	Disable free play mode
BTN_FREEPLAY_ON		Enable free play mode
BTN_GUI_DOWN		Move selection pointer down one row
BTN_GUI_LEFT		Move selection pointer left one column
BTN_GUI_NEXT		Moves the focus to the next control. By default, BTN_GUI_NEXT is mapped to the Tab key.
BTN_GUI_PREV		Moves the focus to the previous control. By default, BTN_GUI_PREV is not mapped.
BTN_GUI_RIGHT		Move selection pointer right one column
BTN_GUI_SELECT		Attempt to add card at current selectionPointer to playlist.
BTN_GUI_UP			Move selection pointer up one row
BTN_LASTPG			Move selection pointer to last page of media.
BTN_LOOP			Toggle Loop Mode
BTN_NEXTALPHA		Move selection pointer to first card of next alphanumeric value.
BTN_NEXTPG			Move selection pointer to first card of next page.
BTN_PAUSE			Toggle pause on/off.
BTN_PAUSE_OFF		Unpause the current song, if the song is already paused.
BTN_PAUSE_ON		Pause the currently playing song.
BTN_PLAYSTIMULATOR
BTN_POPULAR
BTN_PREVALPHA		Move selection pointer to first card of previous alphanumeric value.
BTN_PREVPG			Move selection pointer to first card of previous page.
BTN_RADIO			Toggle radio mode on/off.
BTN_RADIO_OFF
BTN_RADIO_ON
BTN_RANDOM			Select and queue a random song.
BTN_SCREENSHOT		Take a screenshot, store it in [screenshotDir]
BTN_SELECT			Here, we're making it just trigger the queing of the currently selected card.
BTN_SHUFFLE			Reorganise the songs in the queue, placing them in a random order.
BTN_SHUTDOWN		Perform housekeeping, and exit.
BTN_SKIP			Cancels the currently playing song and starts the next song in the queue.
BTN_SKIP_ALBUM		Cancels the currently playing song and skips forward to the next album in the queue.
BTN_SKIPBACK		This allows the user to skip backwards in the queue, to the most recently completed song.
BTN_SKIPLAST		Deletes the last song in the queue.
BTN_SKIN_1-BTN_SKIN_20		Select Skin [skinNumber] for display.
BTN_SKIN_NEXT		Select the next skin for display (increment skin number by 1)
BTN_SKIN_PREV		Select the previous skin for display (decrement skin number by 1)
BTN_TOPTUNE			Select the most-played song on the popularity list.
BTN_TRANS_DOWN		Decrease the overlay transparency (increase opacity of video playback)
BTN_TRANS_UP		Increase the overlay transparency (decrease opacity of video playback)
BTN_VOL_DOWN		Decrease playback volume by defined increment.
BTN_VOL_MAX			Increase playback volume to 100%.
BTN_VOL_MIN			Decrease playback volume to 1%.
BTN_VOL_MUTE		Decrease playback volume to 0%.
BTN_VOL_UP			Increase playback volume by defined increment.
BTN_ZOOM			Expand/contract the mini-display of media to fill entire screen.
